<?php
namespace App\Controllers;

use App\Controllers\BaseController; // Menggunakan BaseController standar CI
use CodeIgniter\Controller; // Tidak perlu, karena sudah extends BaseController/Controller

class AuthController extends BaseController
{
    // 1. Menampilkan halaman login (Dipanggil oleh GET admin/login)
    public function login()
    {
        // Session key yang digunakan: 'isLoggedIn'
        // Pengecekan sesi: Jika sesi 'isLoggedIn' bernilai TRUE
        if (session()->get('isLoggedIn')) {
            // Redirect ke halaman dashboard admin
            session()->setFlashdata('success', 'Anda sudah login. Silakan Logout jika ingin berganti akun.');
            return redirect()->to(base_url('admin/dashboard'));
        }
        // Jika tidak ada sesi 'isLoggedIn' (atau bernilai FALSE), tampilkan form login
        // Pastikan nama view sesuai dengan file login Anda
        return view('admin_login');
    }

    // 2. Memproses form login (Dipanggil oleh POST admin/auth)
    public function attemptLogin()
    {
        $session = session();

        // --- PENTING: Lakukan validasi input sebelum diproses ---
        // Tanpa ini, form Anda rentan.
        $rules = [
            'email' => 'required', // Nama input dari view: name="email"
            'password' => 'required'
        ];

        if (!$this->validate($rules)) {
            // Jika validasi gagal, kembali ke form login dengan pesan error
            return redirect()->back()->withInput()->with('error', 'Username/Email dan Password harus diisi.');
        }

        // Ambil data POST. Name input di view adalah 'email' dan 'password'.
        $input_username = $this->request->getPost('email');
        $input_password = $this->request->getPost('password');

        // --- Logika Verifikasi (Contoh Statis) ---
        $validUsername = 'sjulaeha';
        $validPassword = 'admin123';

        // HANYA VERIFIKASI STATIS, GANTI DENGAN MODEL/DB PADA PROYEK NYATA!
        if ($input_username == $validUsername && $input_password == $validPassword) {
            // Berhasil login
            $session->set([
                'isLoggedIn' => true,
                'username' => $input_username,
                'id' => 1 // Contoh ID user
            ]);

            // REDIRECT BERHASIL KE HALAMAN ADMIN/DASHBOARD
            return redirect()->to(base_url('admin/dashboard'))->with('success', 'Selamat datang, admin!');

        } else {
            // Gagal login
            $session->setFlashdata('error', 'Username atau Password salah.');
            return redirect()->back()->withInput();
        }
    }

    // 3. Logout
    public function logout()
    {
        session()->destroy();
        // Pastikan Anda juga menghapus semua data sesi sebelum redirect
        // Untuk memastikan sesi benar-benar hilang, saya menambahkan session()->destroy()
        return redirect()->to(base_url('admin/login'))->with('success', 'Anda telah berhasil logout.');
    }
}