<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class PortfolioSetup extends Migration
{
    public function up()
    {
        // 1. Activities Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'title' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'date_activity' => [ // Changed from 'date' to avoid reserved word issues
                'type' => 'DATE',
            ],
            'time_activity' => [ // Changed from 'time'
                'type' => 'TIME',
            ],
            'image' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('activities');

        // 2. Education Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'institution' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'degree' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'start_year' => [
                'type' => 'VARCHAR', # Using VARCHAR for flexibility (e.g. "2020")
                'constraint' => '4',
            ],
            'end_year' => [
                'type' => 'VARCHAR',
                'constraint' => '4',
                'null' => true,
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('education');

        // 3. Biodata Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'name' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'job_title' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'null' => true,
            ],
            'address' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'email' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'phone' => [
                'type' => 'VARCHAR',
                'constraint' => '20',
                'null' => true,
            ],
            'summary' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'photo' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('biodata');

        // Allow for the User table correction if needed, but not prioritizing it over the content tables
    }

    public function down()
    {
        $this->forge->dropTable('activities');
        $this->forge->dropTable('education');
        $this->forge->dropTable('biodata');
    }
}
