<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card border-0 shadow-sm" style="border-radius: 15px;">
            <div class="card-header bg-white border-bottom-0 py-3" style="border-radius: 15px 15px 0 0;">
                <h5 class="mb-0 fw-bold" style="color: var(--primary-color);">Edit Profil Biodata</h5>
            </div>
            <div class="card-body p-4">
                <form action="<?= base_url('admin/biodata/update/' . $profile['id']) ?>" method="post"
                    enctype="multipart/form-data">
                    <?= csrf_field() ?>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="name" class="form-label fw-bold small text-muted text-uppercase">Nama
                                Lengkap</label>
                            <input type="text"
                                class="form-control <?= ($validation->hasError('name')) ? 'is-invalid' : ''; ?>"
                                id="name" name="name" value="<?= old('name', $profile['name'] ?? '') ?>" required>
                            <div class="invalid-feedback">
                                <?= $validation->getError('name'); ?>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="job_title" class="form-label fw-bold small text-muted text-uppercase">Job Title
                                / Profesi</label>
                            <input type="text" class="form-control" id="job_title" name="job_title"
                                value="<?= old('job_title', $profile['job_title'] ?? '') ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label fw-bold small text-muted text-uppercase">Email</label>
                            <input type="email"
                                class="form-control <?= ($validation->hasError('email')) ? 'is-invalid' : ''; ?>"
                                id="email" name="email" value="<?= old('email', $profile['email'] ?? '') ?>" required>
                            <div class="invalid-feedback">
                                <?= $validation->getError('email'); ?>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label fw-bold small text-muted text-uppercase">Nomor
                                Telepon</label>
                            <input type="text" class="form-control" id="phone" name="phone"
                                value="<?= old('phone', $profile['phone'] ?? '') ?>">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="address" class="form-label fw-bold small text-muted text-uppercase">Alamat</label>
                        <textarea class="form-control" id="address" name="address"
                            rows="2"><?= old('address', $profile['address'] ?? '') ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="summary" class="form-label fw-bold small text-muted text-uppercase">Ringkasan
                            Diri</label>
                        <textarea class="form-control" id="summary" name="summary"
                            rows="4"><?= old('summary', $profile['summary'] ?? '') ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="photo" class="form-label fw-bold small text-muted text-uppercase">Foto
                            Profil</label>
                        <div class="mb-2">
                            <?php if (!empty($profile['photo'])): ?>
                                <img src="<?= base_url('uploads/biodata/' . $profile['photo']) ?>" alt="Current Photo"
                                    class="rounded-circle shadow-sm" style="width: 80px; height: 80px; object-fit: cover;">
                            <?php else: ?>
                                <div class="rounded-circle bg-light d-flex align-items-center justify-content-center"
                                    style="width: 80px; height: 80px;">
                                    <i class="fas fa-user fa-2x text-muted"></i>
                                </div>
                            <?php endif; ?>
                            <span class="ms-2 small text-muted">Upload baru untuk mengganti foto.</span>
                        </div>
                        <input class="form-control <?= ($validation->hasError('photo')) ? 'is-invalid' : ''; ?>"
                            type="file" id="photo" name="photo" accept="image/*">
                        <div class="invalid-feedback">
                            <?= $validation->getError('photo'); ?>
                        </div>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?= base_url('admin/biodata') ?>" class="btn btn-light me-md-2"
                            style="color: #666;">Batal</a>
                        <button type="submit" class="btn text-white px-4"
                            style="background-color: var(--primary-color);">Simpan Perubahan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>