<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card border-0 shadow-sm" style="border-radius: 15px;">
            <div class="card-header bg-white border-bottom-0 py-3" style="border-radius: 15px 15px 0 0;">
                <h5 class="mb-0 fw-bold" style="color: var(--primary-color);">Edit Riwayat Pendidikan</h5>
            </div>
            <div class="card-body p-4">
                <form action="<?= base_url('admin/education/update/' . $education['id']) ?>" method="post">
                    <?= csrf_field() ?>

                    <div class="mb-3">
                        <label for="institution" class="form-label fw-bold small text-muted text-uppercase">Nama
                            Institusi</label>
                        <input type="text"
                            class="form-control <?= ($validation->hasError('institution')) ? 'is-invalid' : ''; ?>"
                            id="institution" name="institution"
                            value="<?= old('institution', $education['institution']) ?>" required>
                        <div class="invalid-feedback">
                            <?= $validation->getError('institution'); ?>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="degree" class="form-label fw-bold small text-muted text-uppercase">Gelar / Jurusan
                            (Opsional)</label>
                        <input type="text"
                            class="form-control <?= ($validation->hasError('degree')) ? 'is-invalid' : ''; ?>"
                            id="degree" name="degree" value="<?= old('degree', $education['degree']) ?>">
                        <div class="invalid-feedback">
                            <?= $validation->getError('degree'); ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="start_year" class="form-label fw-bold small text-muted text-uppercase">Tahun
                                Mulai</label>
                            <input type="number"
                                class="form-control <?= ($validation->hasError('start_year')) ? 'is-invalid' : ''; ?>"
                                id="start_year" name="start_year"
                                value="<?= old('start_year', $education['start_year']) ?>" required>
                            <div class="invalid-feedback">
                                <?= $validation->getError('start_year'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="end_year" class="form-label fw-bold small text-muted text-uppercase">Tahun
                                Selesai</label>
                            <input type="text" class="form-control" id="end_year" name="end_year"
                                value="<?= old('end_year', $education['end_year']) ?>">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="description" class="form-label fw-bold small text-muted text-uppercase">Deskripsi
                            (Opsional)</label>
                        <textarea class="form-control" id="description" name="description"
                            rows="3"><?= old('description', $education['description']) ?></textarea>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?= base_url('admin/education') ?>" class="btn btn-light me-md-2"
                            style="color: #666;">Batal</a>
                        <button type="submit" class="btn text-white px-4"
                            style="background-color: var(--primary-color);">Update Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>