<?php
// Shared Color Palette (Same as Biodata)
$color_d = '#645c55';   // Dark Brown (Headlines)
$color_h = '#faae2b';   // Highlight (Yellow Orange)
$color_c = '#e3ddd5';   // Beige (Backgrounds)
$color_bg = '#f2f7f5';  // Page Background
$color_text = '#475d5b'; // Text
?>

<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>

<style>
    body {
        background-color:
            <?= $color_bg ?>
        ;
    }

    /* Hero Section similar to Biodata but slightly different */
    .edu-hero {
        background-color:
            <?= $color_c ?>
        ;
        padding: 60px 0 80px 0;
        text-align: center;
        border-bottom-left-radius: 50% 20px;
        border-bottom-right-radius: 50% 20px;
    }

    .edu-hero h1 {
        font-family: 'Playfair Display', serif;
        font-weight: 700;
        font-size: 2.5rem;
        color:
            <?= $color_d ?>
        ;
        margin-bottom: 10px;
    }

    .edu-hero p {
        font-family: 'Montserrat', sans-serif;
        color:
            <?= $color_text ?>
        ;
        letter-spacing: 1px;
    }

    /* Timeline Container */
    .timeline-section {
        padding: 60px 0;
        position: relative;
        margin-top: -50px;
        /* Overlap */
    }

    .timeline {
        position: relative;
        max-width: 800px;
        margin: 0 auto;
        padding: 20px 0;
    }

    /* The Vertical Line */
    .timeline::after {
        content: '';
        position: absolute;
        width: 4px;
        background-color:
            <?= $color_d ?>
        ;
        top: 0;
        bottom: 0;
        left: 50%;
        margin-left: -2px;
        border-radius: 2px;
        opacity: 0.2;
    }

    /* Timeline Container Boxes */
    .timeline-container {
        padding: 10px 40px;
        position: relative;
        background-color: inherit;
        width: 50%;
        animation: slideUp 0.8s ease forwards;
        opacity: 0;
    }

    /* Left and Right containers */
    .left {
        left: 0;
        text-align: right;
    }

    .right {
        left: 50%;
        text-align: left;
    }

    /* The circles on the timeline */
    .timeline-container::after {
        content: '';
        position: absolute;
        width: 20px;
        height: 20px;
        right: -10px;
        background-color:
            <?= $color_bg ?>
        ;
        border: 4px solid
            <?= $color_h ?>
        ;
        top: 25px;
        border-radius: 50%;
        z-index: 1;
        transition: all 0.3s ease;
    }

    .right::after {
        left: -10px;
    }

    .timeline-container:hover::after {
        background-color:
            <?= $color_h ?>
        ;
        transform: scale(1.2);
    }

    /* Content Box */
    .content-box {
        padding: 20px 30px;
        background-color: white;
        position: relative;
        border-radius: 15px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border: 1px solid rgba(0, 0, 0, 0.02);
    }

    .content-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        border-color:
            <?= $color_h ?>
        ;
    }

    .content-box h2 {
        font-family: 'Playfair Display', serif;
        font-size: 1.5rem;
        color:
            <?= $color_d ?>
        ;
        margin-bottom: 5px;
    }

    .content-box .period {
        font-family: 'Montserrat', sans-serif;
        font-weight: 600;
        color:
            <?= $color_h ?>
        ;
        font-size: 0.9rem;
        margin-bottom: 10px;
        display: block;
        text-transform: uppercase;
    }

    .content-box p {
        font-family: 'Montserrat', sans-serif;
        font-size: 0.95rem;
        color:
            <?= $color_text ?>
        ;
        margin: 0;
    }

    /* Arrows */
    .left .content-box::before {
        content: " ";
        height: 0;
        position: absolute;
        top: 22px;
        width: 0;
        z-index: 1;
        right: -10px;
        border: medium solid white;
        border-width: 10px 0 10px 10px;
        border-color: transparent transparent transparent white;
    }

    .right .content-box::before {
        content: " ";
        height: 0;
        position: absolute;
        top: 22px;
        width: 0;
        z-index: 1;
        left: -10px;
        border: medium solid white;
        border-width: 10px 10px 10px 0;
        border-color: transparent white transparent transparent;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .timeline::after {
            left: 31px;
        }

        .timeline-container {
            width: 100%;
            padding-left: 70px;
            padding-right: 25px;
        }

        .timeline-container::after {
            left: 21px;
        }

        .left::before,
        .right::before {
            left: 60px;
            border: medium solid white;
            border-width: 10px 10px 10px 0;
            border-color: transparent white transparent transparent;
        }

        .left,
        .right {
            text-align: left;
        }

        .left .content-box::before {
            right: auto;
            left: -10px;
            border-width: 10px 10px 10px 0;
            border-color: transparent white transparent transparent;
        }
    }

    /* Animation Delays */
    .timeline-container:nth-child(1) {
        animation-delay: 0.1s;
    }

    .timeline-container:nth-child(2) {
        animation-delay: 0.3s;
    }

    .timeline-container:nth-child(3) {
        animation-delay: 0.5s;
    }

    .timeline-container:nth-child(4) {
        animation-delay: 0.7s;
    }

    @keyframes slideUp {
        from {
            transform: translateY(50px);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
</style>

<!-- Hero -->
<div class="edu-hero">
    <div class="container">
        <h1>Riwayat Pendidikan</h1>
        <p>Perjalanan Akademik & Pembelajaran</p>
    </div>
</div>

<!-- Search & Sort Section -->
<div class="container" style="margin-top: -30px; position: relative; z-index: 10; margin-bottom: 40px;">
    <div class="row justify-content-center">
        <div class="col-md-9">
            <form action="" method="get" id="sortForm">

                <div class="d-flex flex-column flex-md-row gap-3 align-items-center justify-content-between p-3 bg-white shadow-sm rounded-pill"
                    style="border: 1px solid rgba(0,0,0,0.05);">

                    <!-- Search Input -->
                    <div class="d-flex align-items-center flex-grow-1 w-100 px-2">
                        <i class="fas fa-search text-muted mr-2"></i>
                        <input type="text" name="q" value="<?= esc($search) ?>"
                            class="form-control border-0 shadow-none p-0" placeholder="Cari nama sekolah..."
                            style="background: transparent;">
                    </div>

                    <!-- Separator on desktop -->
                    <div class="d-none d-md-block" style="width: 1px; height: 30px; background: #eee;"></div>

                    <!-- Sort Controls -->
                    <div class="d-flex align-items-center mt-2 mt-md-0 w-100 w-md-auto justify-content-end flex-wrap"
                        style="gap: 10px;">
                        <span class="mr-2 text-muted font-weight-bold"
                            style="font-size: 0.9rem; white-space: nowrap;">Urutkan:</span>

                        <!-- Tahun Dropdown (Sort & Filter) -->
                        <div class="dropdown d-inline-block">
                            <button class="btn btn-sm dropdown-toggle d-flex align-items-center" type="button"
                                id="sortYear" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="border-radius: 10px; padding: 8px 15px; 
                                       background-color: <?= ($sort == 'year' || $year_filter) ? 'rgba(250, 174, 43, 0.15)' : 'white' ?>; 
                                       color: <?= ($sort == 'year' || $year_filter) ? '#b37400' : '#555' ?>;
                                       border: 1px solid <?= ($sort == 'year' || $year_filter) ? 'transparent' : '#eee' ?>;
                                       font-weight: 600;">
                                <?= ($year_filter && $year_filter != 'Semua') ? 'Tahun: ' . $year_filter : 'Tahun' ?>
                            </button>
                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="sortYear">
                                <h6 class="dropdown-header">Urutkan</h6>
                                <a class="dropdown-item <?= ($sort == 'year' && $order == 'desc' && !$year_filter) ? 'active' : '' ?>"
                                    href="?q=<?= esc($search) ?>&sort=year&order=desc&level_filter=<?= esc($level_filter) ?>">Terbaru</a>
                                <a class="dropdown-item <?= ($sort == 'year' && $order == 'asc' && !$year_filter) ? 'active' : '' ?>"
                                    href="?q=<?= esc($search) ?>&sort=year&order=asc&level_filter=<?= esc($level_filter) ?>">Terlama</a>

                                <div class="dropdown-divider"></div>
                                <h6 class="dropdown-header">Filter Tahun</h6>
                                <a class="dropdown-item <?= (!$year_filter || $year_filter == 'Semua') ? '' : '' ?>"
                                    href="?q=<?= esc($search) ?>&level_filter=<?= esc($level_filter) ?>">Semua Tahun</a>
                                <?php foreach ($unique_years as $y): ?>
                                    <a class="dropdown-item <?= ($year_filter == $y) ? 'active' : '' ?>"
                                        href="?q=<?= esc($search) ?>&year_filter=<?= $y ?>&level_filter=<?= esc($level_filter) ?>">Tahun
                                        <?= $y ?></a>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <!-- Jenjang Button -->
                        <a href="?q=<?= esc($search) ?>&sort=level&order=<?= ($sort == 'level' && $order == 'asc') ? 'desc' : 'asc' ?>&year_filter=<?= esc($year_filter) ?>&level_filter=<?= esc($level_filter) ?>"
                            class="btn btn-sm d-flex align-items-center" style="border-radius: 10px; padding: 8px 15px; 
                                  background-color: <?= ($sort == 'level') ? 'rgba(250, 174, 43, 0.15)' : 'white' ?>; 
                                  color: <?= ($sort == 'level') ? '#b37400' : '#555' ?>;
                                  border: 1px solid <?= ($sort == 'level') ? 'transparent' : '#eee' ?>;
                                  font-weight: 600;
                                  white-space: nowrap;">
                            Jenjang
                            <?php if ($sort == 'level'): ?>
                                <i class="fas fa-sort-<?= $order == 'asc' ? 'amount-down' : 'amount-up' ?> ml-2"></i>
                            <?php endif; ?>
                        </a>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>

<style>
    /* Styling for Dropdown Items Active State - Orange/Gold */
    .dropdown-item.active,
    .dropdown-item:active {
        background-color:
            <?= $color_h ?>
        ;
        color: #fff;
    }

    .dropdown-header {
        color:
            <?= $color_d ?>
        ;
        font-weight: 600;
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
</style>

<!-- Timeline -->
<div class="timeline-section">
    <div class="container">

        <?php if (empty($education)): ?>
            <div class="text-center py-5">
                <i class="fas fa-search mb-3" style="font-size: 3rem; color: #ddd;"></i>
                <p style="color: <?= $color_text ?>; font-family: 'Montserrat', sans-serif;">Data tidak ditemukan.</p>
                <a href="?" class="btn btn-sm btn-outline-secondary" style="border-radius: 20px;">Reset Pencarian</a>
            </div>
        <?php else: ?>

            <div class="timeline">
                <?php $i = 0; ?>
                <?php foreach ($education as $item): ?>
                    <?php $side = ($i % 2 == 0) ? 'left' : 'right'; ?>

                    <div class="timeline-container <?= $side ?>">
                        <div class="content-box">
                            <span class="period"><?= esc($item['year_start']) ?> - <?= esc($item['year_end']) ?></span>
                            <h2><?= esc($item['school']) ?></h2>
                            <p><?= esc($item['level']) ?></p>
                        </div>
                    </div>

                    <?php $i++; ?>
                <?php endforeach; ?>
            </div>

            <!-- Pagination Links -->
            <?php if ($totalPages >= 1): ?>
                <div class="mt-5 d-flex justify-content-center">
                    <nav aria-label="Page navigation">
                        <ul class="pagination">
                            <!-- Prev -->
                            <?php if ($totalPages > 1): ?>
                                <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                                    <a class="page-link"
                                        href="?q=<?= esc($search) ?>&sort=<?= esc($sort) ?>&order=<?= esc($order) ?>&page=<?= $page - 1 ?>&level_filter=<?= esc($level_filter) ?>&year_filter=<?= esc($year_filter) ?>"
                                        aria-label="Previous">
                                        <span aria-hidden="true">&laquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <!-- Page Numbers -->
                            <?php for ($p = 1; $p <= $totalPages; $p++): ?>
                                <li class="page-item <?= ($page == $p) ? 'active' : '' ?>">
                                    <a class="page-link"
                                        style="<?= ($page == $p) ? 'background-color: #6c757d; border-color: #6c757d;' : 'color: #645c55;' ?>"
                                        href="?q=<?= esc($search) ?>&sort=<?= esc($sort) ?>&order=<?= esc($order) ?>&page=<?= $p ?>&level_filter=<?= esc($level_filter) ?>&year_filter=<?= esc($year_filter) ?>"><?= $p ?></a>
                                </li>
                            <?php endfor; ?>

                            <!-- Next -->
                            <?php if ($totalPages > 1): ?>
                                <li class="page-item <?= ($page >= $totalPages) ? 'disabled' : '' ?>">
                                    <a class="page-link"
                                        href="?q=<?= esc($search) ?>&sort=<?= esc($sort) ?>&order=<?= esc($order) ?>&page=<?= $page + 1 ?>&level_filter=<?= esc($level_filter) ?>&year_filter=<?= esc($year_filter) ?>"
                                        aria-label="Next">
                                        <span aria-hidden="true">&raquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
            <?php endif; ?>

        <?php endif; ?>
    </div>
</div>

<?= $this->endSection() ?>